/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.keyboards;

import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyCraftingZone;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyZone;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class KeyCaps {
    public int[] craftingValues = new int[25];
    public int craftingNulls = 0;
    public static final String KEY_CAP_KEY = "key_caps";
    public static final String CRAFTING_VALUES_KEY = "crafting_values";
    public static final String CRAFTING_NULLS_KEY = "crafting_nulls";
    public static final int DEFAULT_COLOR = 0x1D1D21;

    public static KeyCaps fromNBT(class_2487 nbt) {
        KeyCaps keyCaps = new KeyCaps();
        if (nbt != null && nbt.method_10573(CRAFTING_NULLS_KEY, 3)) {
            keyCaps.craftingNulls = nbt.method_10550(CRAFTING_NULLS_KEY);
            if (nbt.method_10573(CRAFTING_VALUES_KEY, 11)) {
                keyCaps.craftingValues = nbt.method_10561(CRAFTING_VALUES_KEY);
            }
        }
        return keyCaps;
    }

    public static KeyCaps fromItemStack(class_1799 itemStack) {
        class_2487 nbt = itemStack.method_7941(KEY_CAP_KEY);
        return KeyCaps.fromNBT(nbt);
    }

    public class_2487 toSubNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10569(CRAFTING_NULLS_KEY, this.craftingNulls);
        nbt.method_10539(CRAFTING_VALUES_KEY, this.craftingValues);
        return nbt;
    }

    public static class_1799 changeColor(class_1799 itemStack, int color, int craftingIndex) {
        KeyCaps keyCaps = KeyCaps.fromItemStack(itemStack);
        keyCaps.changeColor(color, craftingIndex);
        class_2487 nbt = itemStack.method_7911(KEY_CAP_KEY);
        nbt.method_10566(KEY_CAP_KEY, (class_2520)keyCaps.toSubNBT());
        return itemStack;
    }

    public void changeColor(int newColor, int craftingIndex) {
        this.craftingValues[craftingIndex] = newColor;
        this.craftingNulls |= 1 << craftingIndex;
    }

    public static int blendColors(int color1, int color2) {
        int[] is = new int[3];
        int i = 0;
        int j = 0;
        float f = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float h = (float)(color1 & 0xFF) / 255.0f;
        i += (int)(Math.max(f, Math.max(g, h)) * 255.0f);
        is[0] = is[0] + (int)(f * 255.0f);
        is[1] = is[1] + (int)(g * 255.0f);
        is[2] = is[2] + (int)(h * 255.0f);
        ++j;
        float[] fs = new float[]{(float)((color2 & 0xFF0000) >> 16) / 255.0f, (float)((color2 & 0xFF00) >> 8) / 255.0f, (float)((color2 & 0xFF) >> 0) / 255.0f};
        int l = (int)(fs[0] * 255.0f);
        int m = (int)(fs[1] * 255.0f);
        int n = (int)(fs[2] * 255.0f);
        i += Math.max(l, Math.max(m, n));
        is[0] = is[0] + l;
        is[1] = is[1] + m;
        is[2] = is[2] + n;
        int k = is[0] / ++j;
        int o = is[1] / j;
        int p = is[2] / j;
        h = (float)i / (float)j;
        float q = Math.max(k, Math.max(o, p));
        k = (int)((float)k * h / q);
        o = (int)((float)o * h / q);
        p = (int)((float)p * h / q);
        n = k;
        n = (n << 8) + o;
        n = (n << 8) + p;
        return n;
    }

    public void blendAndSetColor(int newColor, int craftingIndex) {
        if (this.isDefault(craftingIndex)) {
            this.changeColor(newColor, craftingIndex);
            return;
        }
        int oldColor = this.craftingValues[craftingIndex];
        int blendedColor = KeyCaps.blendColors(oldColor, newColor);
        this.changeColor(blendedColor, craftingIndex);
    }

    public void removeColor(int craftingIndex) {
        this.craftingValues[craftingIndex] = 0x1D1D21;
        this.craftingNulls &= ~(1 << craftingIndex);
    }

    public void logSelf() {
        DuckyPeriphs.logPrint("KeyCaps: " + this.craftingNulls);
    }

    public boolean isDefault() {
        return this.craftingNulls == 0;
    }

    public boolean isDefault(int cZone) {
        return (1 << cZone & this.craftingNulls) == 0;
    }

    public boolean isDefault(KeyCraftingZone cZone) {
        return (1 << cZone.id & this.craftingNulls) == 0;
    }

    public int getZoneColor(KeyZone zone) {
        return this.getZoneColor(zone.tintIndex());
    }

    public static boolean isZoneType(int tintIndex, KeyZone[] zoneType) {
        for (KeyZone zone : zoneType) {
            if (zone.tintIndex() != tintIndex) continue;
            return true;
        }
        return false;
    }

    public class_2561 getDisplayText(KeyZone keyZone) {
        int keyColor = this.getZoneColor(keyZone);
        if (keyColor == 0x1D1D21) {
            return null;
        }
        return class_2561.method_43471((String)keyZone.getName()).method_10852(class_2561.method_30163((String)": #")).method_10852(class_2561.method_30163((String)Integer.toHexString(keyColor)));
    }

    class_2561 getDisplayText(KeyCraftingZone keyCraftingZone) {
        if (this.isDefault(keyCraftingZone)) {
            return null;
        }
        int keyColor = this.craftingValues[keyCraftingZone.id];
        class_5250 colorIndicatorText = class_2561.method_43470((String)"\u2665").method_10862(class_2583.field_24360.method_36139(keyColor));
        class_5250 colorText = class_2561.method_43470((String)": #").method_10852(class_2561.method_30163((String)Integer.toHexString(keyColor))).method_27692(class_124.field_1080).method_10852((class_2561)colorIndicatorText);
        return class_2561.method_43471((String)keyCraftingZone.getNameKey()).method_27692(class_124.field_1080).method_10852((class_2561)colorText);
    }

    public int getZoneColor(int tintIndex) {
        if (this.isDefault()) {
            return 0x1D1D21;
        }
        if (KeyCaps.isZoneType(tintIndex, KeyZone.CASE_ZONES)) {
            boolean have_main = !this.isDefault(KeyCraftingZone.CASE_MAIN);
            boolean have_left = !this.isDefault(KeyCraftingZone.CASE_LEFT);
            boolean have_right = !this.isDefault(KeyCraftingZone.CASE_RIGHT);
            boolean is_main = KeyCaps.isZoneType(tintIndex, KeyZone.CASE_ZONES_M);
            boolean is_left = KeyCaps.isZoneType(tintIndex, KeyZone.CASE_ZONES_L);
            boolean is_right = KeyCaps.isZoneType(tintIndex, KeyZone.CASE_ZONES_R);
            if (have_main && !have_left && !have_right) {
                return this.craftingValues[KeyCraftingZone.CASE_MAIN.id];
            }
            if (!have_main && have_left && have_right) {
                return is_left ? this.craftingValues[KeyCraftingZone.CASE_LEFT.id] : this.craftingValues[KeyCraftingZone.CASE_RIGHT.id];
            }
            if (have_main && have_left && have_right) {
                if (is_main) {
                    return this.craftingValues[KeyCraftingZone.CASE_MAIN.id];
                }
                if (is_left) {
                    return this.craftingValues[KeyCraftingZone.CASE_LEFT.id];
                }
                if (is_right) {
                    return this.craftingValues[KeyCraftingZone.CASE_RIGHT.id];
                }
            }
            if (!(have_main || have_left || have_right)) {
                return 0x1D1D21;
            }
            if (have_main && !have_left && have_right) {
                return is_left || is_main ? this.craftingValues[KeyCraftingZone.CASE_MAIN.id] : this.craftingValues[KeyCraftingZone.CASE_RIGHT.id];
            }
            if (have_main && have_left && !have_right) {
                return is_right || is_main ? this.craftingValues[KeyCraftingZone.CASE_MAIN.id] : this.craftingValues[KeyCraftingZone.CASE_LEFT.id];
            }
            if (have_left && is_left) {
                return this.craftingValues[KeyCraftingZone.CASE_LEFT.id];
            }
            if (have_right && is_right) {
                return this.craftingValues[KeyCraftingZone.CASE_RIGHT.id];
            }
            return 0x1D1D21;
        }
        if (KeyCaps.isZoneType(tintIndex, KeyZone.FN_ZONES)) {
            if (!this.isDefault(KeyCraftingZone.FN_LEFT) && KeyZone.LEFT_FN_KEYS.equals(tintIndex)) {
                return this.craftingValues[KeyCraftingZone.FN_LEFT.id];
            }
            if (!this.isDefault(KeyCraftingZone.FN_RIGHT) && KeyZone.RIGHT_FN_KEYS.equals(tintIndex)) {
                return this.craftingValues[KeyCraftingZone.FN_RIGHT.id];
            }
            if (!this.isDefault(KeyCraftingZone.FN_MAIN)) {
                return this.craftingValues[KeyCraftingZone.FN_MAIN.id];
            }
        }
        if (!this.isDefault(KeyCraftingZone.TAB) && KeyZone.TAB_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.TAB.id];
        }
        if (!this.isDefault(KeyCraftingZone.ESC) && KeyZone.ESC_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.ESC.id];
        }
        if (!this.isDefault(KeyCraftingZone.CAPS) && KeyZone.CAPS_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.CAPS.id];
        }
        if (!this.isDefault(KeyCraftingZone.LSHIFT) && KeyZone.LSHIFT.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.LSHIFT.id];
        }
        if (!this.isDefault(KeyCraftingZone.RSHIFT) && KeyZone.RSHIFT.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.RSHIFT.id];
        }
        if (!this.isDefault(KeyCraftingZone.SPACE) && KeyZone.SPACE_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.SPACE.id];
        }
        if (!this.isDefault(KeyCraftingZone.ENTER) && KeyZone.ENTER_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.ENTER.id];
        }
        if (!this.isDefault(KeyCraftingZone.BACKSPACE) && KeyZone.BACK_KEY.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.BACKSPACE.id];
        }
        if (!this.isDefault(KeyCraftingZone.LEFT_MODIFIERS) && KeyZone.MODIFIER_KEYS_LEFT.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.LEFT_MODIFIERS.id];
        }
        if (!this.isDefault(KeyCraftingZone.RIGHT_MODIFIERS) && KeyZone.MODIFIER_KEYS_RIGHT.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.RIGHT_MODIFIERS.id];
        }
        if (!this.isDefault(KeyCraftingZone.NUM_ROW) && KeyZone.NUM_ROW.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.NUM_ROW.id];
        }
        if (!this.isDefault(KeyCraftingZone.WASD) && KeyZone.WASD_KEYS.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.WASD.id];
        }
        if (!this.isDefault(KeyCraftingZone.ARROWS) && KeyZone.ARROW_KEYS.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.ARROWS.id];
        }
        if (!this.isDefault(KeyCraftingZone.SCREEN_KEYS) && KeyZone.SCREEN_KEYS.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.SCREEN_KEYS.id];
        }
        if (!this.isDefault(KeyCraftingZone.SIDE_TOP) && KeyZone.TOP_SIDE_KEYS.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.SIDE_TOP.id];
        }
        if (!this.isDefault(KeyCraftingZone.SIDE_MID) && KeyZone.MID_SIDE_KEYS.equals(tintIndex)) {
            return this.craftingValues[KeyCraftingZone.SIDE_MID.id];
        }
        if (!this.isDefault(KeyCraftingZone.UTIL_KEYS) && KeyCaps.isZoneType(tintIndex, KeyZone.UTIL_ZONES)) {
            return this.craftingValues[KeyCraftingZone.UTIL_KEYS.id];
        }
        if (!this.isDefault(KeyCraftingZone.MAIN.zone())) {
            return this.craftingValues[KeyCraftingZone.MAIN.zone()];
        }
        return 0x1D1D21;
    }
}

